MObject->Fields(

  c_hit => {default => 0, noinherit => 1},
  c_move => {default => 0, noinherit => 1},
  m_hit => {default => 0},
  m_move => {default => 0},

  has_metabolism => {default => 0},

  weight => {default => 999999},
  density => {default => 1},
  ldesc => {default => 'You see nothing special.'},
  idesc => {default => 'MISSING I-DESC'},
  extra_descs => {default => []},
  
  glance_contents => {default => 0},
  enter_prep => {default => 'in'},
  sky_vis => {default => 1}, # fraction of sunlight that gets to this room - e.g. dense forest might use .1

  # Observability
  invisible => {default => 0},
  mute => {default => 0},
  blind => {default => 0},
  deaf => {default => 0},

  # Containers
  cnt_interior => {default => 0},
  cnt_type => {default => 'hard'}, # hard, soft, open
  cnt_slot_nomax => {default => 0},

  doing => {},

  last_mentioned_object => {default => []},
);


MObject->Commands (
  quit => {
    code => sub {
      my ($self, $args) = @_;
      mudlog($self->name . " has quit.");
      $self->connection->detach;
    },
    help => <<'EOHELP',
Disconnects from your character. This is equivalent to simply breaking your connection, except that it returns you to the menu.
EOHELP
  },
);

my $isin = sub {
  my ($thing, $ary) = @_;
  foreach (@$ary) {
    return 1 if $_ == $thing;
  }
  return 0;
};

MObject->Methods(

can_see => sub {
  my ($self, $other) = @_;
  return 0 if MModules->loaded('body_pos') and !$self->bp_can('look');
  return 0 if $self->blind > 0;
  return 0 if $other->invisible > 0 and !$self->priv_watcher;
  # return 0 if $other->wizinvis;
  1;
},

can_hear => sub {
  my ($self, $other) = @_;
  return 0 if MModules->loaded('body_pos') and !$self->bp_can('hear');
  return 0 if $self->deaf > 0;
  return 0 if $other->mute > 0;
  1;
},


object_scan => sub {
  my ($self, $hook, %param) = @_;
  
  $hook->($self) and return;
  unless ($param{no_self_contents}) {foreach my $obj (@{$self->contents}) {
    if ($obj->glance_contents) {
      $obj->object_scan($hook, no_outside => 1);
    } else {
      $hook->($obj) and return;
    }
  }}  
  if (!$param{no_outside} and my $obj = $self->container) {
    while ($obj->glance_contents) {
      $obj = $obj->container || last;
    }
    # after we find the outermost visible container, we descend thru the tree.
    $obj->object_scan($hook, no_outside => 1);
  }
},

# *** IMPORTANT NOTE: It is the responsibility of the calling routine to determine
# if the object(s) returned by object_find are physically accessible.
object_find => sub {
  my ($self, $name, %param) = @_;
  
  die "CFAIL:What object?" if !$name;
  
  if ($name =~ /and|,/) {
    my @res = map {$self->object_find($_, %param)} grep $_, split /(?:\s*(?:\band\b|,))+\s*/, $name;
    $self->last_mentioned_object([@res]);
    return @res;
  }
  
  if ($name =~ /^(.*)'s\s(.*)$/) {
    my $in = $2;
    my %nok = map {$_, 1} qw(no_self_contents no_outside);
    return $self->object_find($1, %param)->object_find($in, (map {$_, $param{$_}} grep !$nok{$_}, keys %param));
  }
  
  my $caller = $param{'caller'} || $self;
  $name = lc $name;
  
  return $self if $name eq 'self' or $name eq 'me';
  if ($name =~ /^#(\d+)$/ and $caller->priv_watcher) {
    my $obj = MObjectDB->get($1);
    if ($obj) {
      $self->last_mentioned_object([$obj]);
      return $obj;
    } else {
      die "CFAIL:There is no object with that ID.";
    }
  }

  if ($name =~ /^(it|them|they|him|her)$/i) {
    my $word = $1;
    my @found = @{ $self->last_mentioned_object };
    @found or die "CFAIL:What's ".lc($word)."?";
    return wantarray ? @found : $found[0];
  }
  
  $param{no_outside} = 1 if $name =~ s/^my\s+//;
  $param{no_self_contents} = 1 if $name =~ s/^the\s+//;
  my $instance = ($name =~ s/^(all|every\w*)(\.|\s+|$)|(\.|\s+|^)(things|stuff|objects|items)$//) ? -1
               : ($name =~ s/^(\d+)\.// ? $1 : 0)
              || ($name =~ s/\s+(\d+)$// ? $1 : 0)
              || 1;
  $param{no_outside} = 1 if $name =~ s/^my\s+//;
  $param{no_self_contents} = 1 if $name =~ s/^the\s+//;
  # my/the checks twice to handle "my all" as well as "all my food", etc.
 
  delete $param{entire_world} if $instance == -1;
  
  #$caller->send("DEBUG: name after processing: '$name', instance: $instance");
  #$caller->send("Params: " . join ', ', %param);
  
  my @found;
  $self->object_scan(sub {
    my ($obj) = @_;
    return 1 if $instance == 0;
    return if ($caller->container || 0) == $obj and $instance == -1;
    #$caller->send("DEBUG: in scan callback, scanning #".$obj->id.", instance now is $instance");
    
    push @found, $obj if  ( !$name or $obj->name =~ /\b\Q$name\E\b/i 
                                   or ($obj->name_plural||'') =~ /\b\Q$name\E\b/i )
                      and ( $instance == -1 ? $obj != $caller : --$instance == 0 );
    # if $instance == -1, then we're scanning "all", therefore never include self.
                         
    if ($param{extra_descs}) {
      # $self->send("DEBUG: scanning extra descs for #".$obj->id);
      foreach my $descrec (@{$obj->extra_descs}) {
        next unless grep {$_ eq $name} @{$descrec->{keywords} || []};
        push @found, $descrec->{desc} if ($instance != -1 ? $obj != $caller : --$instance == 0);
      }
    }
    return 1 if $instance == 0;
  }, %param);
  
  if ($param{entire_world}) {
    my $iobj = MIndex->get($name);
    push @found, $iobj if $iobj;
  }
  
  if (@found) {
    $self->last_mentioned_object([map {$_->as_ref} (wantarray ? @found : $found[0])]);
    return wantarray ? @found : $found[0];
  } else {
    my $an = $name =~ /^[aeiou]/ ? 'an' : 'a';
    die "CFAIL:You don't "
      . ($param{no_outside} ? 'have ' : 'see ') 
      . ($instance == -1 ? 'any' : $an) 
      . (length($name) ? qq{ "$name"} : 'thing')
      . ($param{no_outside} ? '' : ' here')
      . ($param{entire_world} ? ' or anywhere' : '')
      . '.';
  }
},

nact => sub {
  my ($self, $desc, %objs) = @_;
  
  my %seen;
  #mudlog "DEBUG: nact self is $self args=@_";
  $objs{self} = $self;
  foreach (values %objs) {
    #mudlog "DEBUG: in nact() for $_ ".$_->nphr;
    $_->object_scan(sub {
      my ($o) = @_;
      #mudlog "DEBUG: in nact() scan callback for $o ".$o->nphr;
      return if $seen{$o->id}++;
      return unless $o->uses_output;
      my $msg = $o->desc_gen($desc, %objs);
      $o->send(ucfirst $msg) if $msg;
      0;
    });
  }
},

desc_gen => sub {
  my ($self, $str, %objs) = @_;

  #print "DEBUG: desc_gen for ".$self->nphr."...\n";
  $objs{viewer} = $self;
  if ($str !~ /</) {
    $str = "<self.vis?".$self->dg_escape($str).">";
  }
  #$self->send("parser's getting $str&:n;");
  return $self->_dg_parse(\$str, \%objs);
},


_dg_parse => sub {
  my ($viewer, $str, $objs) = @_;

  my $out = '';
  while (length $$str) {
    $$str =~ s/^( 
      (?:
        (?:&:)?
        [^<>:]+
      )*  
    )//x;
    $out .= $1;
    last unless length $$str and $$str !~ /^[:>]/;
    #print "DEBUG: before tag match, str='$$str'\n";
    $$str =~ s/^<([#\w]+)(?:\.(\w+))?// or $out .= "[parse error: badly formed tag]$$str", goto DONE;
    my ($olabel, $field) = ($1, $2);
    #exists $$objs{$olabel} or die "parse error: undefined object label '$olabel'";
    if ($$str =~ s/^>//) {
      $out .= $viewer->_dg_field($$objs{$olabel} || $olabel, $field || 'nounphrase');
    } elsif ($$str =~ s/^([?!])//) {
      my $not = $1 eq '!';
      $field ||= 'is'; # <self? same as <self.is?
      my $yestr = $viewer->_dg_parse($str, $objs);
      $$str =~ s/^([:>])// or $out .= "[parse error: badly formed <?:> - no : or > found after ?]$$str", goto DONE;
      my $nostr;
      if ($1 eq '>') {
        $nostr = '';
      } else {
        $nostr = $viewer->_dg_parse($str, $objs);
        $$str =~ s/^>// or $out .= "[parse error: badly formed <?:> - no > found after :]$$str", goto DONE;
      }
      $out .= ($viewer->_dg_field($$objs{$olabel} || $olabel, $field) xor $not) ? $yestr : $nostr;
    } else {
      $out .= "[parse error: unknown tag type]<$olabel" . ($field ? ".$field" : '') . $$str;
    }
  }
  DONE: return $out;
},

_dg_field => sub {
  my ($viewer, $obj, $field) = @_;

  if (not ref $obj) {
    if ($obj =~ /^#(.*)$/) {
      # we do a get_real here because it'll be more efficient, and $obj isn't stored anywhere
      $obj = MObjectDB->get_real($1) or return "[MISSING]";
    } else {
      return "[error: undefined object label: $obj]";
    }
  }

  #print "in _dg_field, viewer $viewer, obj $obj, field $field\n";
  if ($field eq 'name') {
    return $obj == $viewer ? 'you' : $viewer->can_see($obj) ? $obj->name : 'something';
  } elsif ($field eq 'nounphrase') {
    return $obj == $viewer ? 'you' : $viewer->can_see($obj) ? $obj->nphr : 'something';
  } elsif ($field eq 'pname') {
    return $obj == $viewer ? 'your' : $viewer->can_see($obj) ? ($obj->name."'s") : "something's";
  } elsif ($field eq 'is') {
    return $obj == $viewer ? 1 : 0;
  } elsif ($field eq 'vis') {
    return ($obj == $viewer or $viewer->can_see($obj)) ? 1 : 0;
  } elsif ($field eq 'aud') {
    return ($obj == $viewer or $viewer->can_hear($obj)) ? 1 : 0;
  } elsif ($field eq 'gendern') {
    return $obj == $viewer ? 'you' : $GENDER_NOM{$obj->gender};
  } elsif ($field eq 'gendero') {
    return $obj == $viewer ? 'yourself' : $GENDER_OBJ{$obj->gender};
  } elsif ($field eq 'genderp') {
    return $obj == $viewer ? 'your' : $GENDER_POSS{$obj->gender};
  } else {
    mudlog "DEBUG: using arbitrary field in _dg_field";
    return $obj->get_val($field);
  }
},

dg_escape => sub {
  my ($self, $str) = @_;
  my %ttab = reverse %{MConnection->char_escapes()};
  $str =~ s/(^|[^&])([<>:])/($1 || '' ) . "&$ttab{$2};"/eg;
  $str;
},
);

Hooks (

prompt_info => sub {
  my ($self) = @_;
  return $self->invisible ? 'invis' : ();
},

object_aging => sub {
  my ($self, $time_passed) = @_;

  return unless $self->has_metabolism;
  my $mult = 1;
  foreach (call_hooks('recovery_modifiers', $self)) { $mult += $_ }
  my $gain = ($self->m_hit / 86400) * 5 * $time_passed * ($self->c_hit / ($self->m_hit || 1));
  $gain = 10^8 if $gain < -(10^2); # overflow protection
  
  #$self->send("TICK: mult total = $mult, gain = $gain");
  
  $self->c_hit($self->c_hit + $gain) <= $self->m_hit or $self->c_hit($self->m_hit)      if ($self->c_hit||0) < $self->m_hit;
  $self->c_move($self->c_move + $gain) <= $self->m_move or $self->c_move($self->m_move) if ($self->c_hit||0) < $self->m_move;
},

);
